<?php

namespace App\Livewire\Auth;

use App\Mail\Admin\PasswordReset;
use App\Models\Admin;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class ResetPassword extends Component
{
    #[Validate('required')]
    public $email;

    public function render()
    {
        return view('livewire.auth.reset-password');
    }

    public function reset_password()
    {
        $this->validate();

        $admin = Admin::firstWhere('email', $this->email);

        if ($admin == null) {
            return $this->addError('email', 'We can\'t find a user with that email address.');
        } else {
            $admin->update([
                'password' => Hash::make(str_replace(' ', '', $admin->name)),
            ]);
            Mail::to($admin->email)->send(new PasswordReset($admin));
            return $this->dispatch('password-sent', 'Password reset sent to email.');
        }
    }
}
