<?php

namespace App\Livewire\Forms;

use App\Models\Tracking;
use Livewire\Attributes\Validate;
use Livewire\Form;

class TrackingForm extends Form
{
    
    #[Validate('required|max:255')]
    public $date_sent;

    #[Validate('required|max:255')]
    public $date_expected;

    #[Validate('required|min:0|max:100')]
    public $progress;

    #[Validate('required|max:255')]
    public $current_location;

    public function setTrackingForm(Tracking $tracking) {
        $this->date_sent = $tracking->date_sent;
        $this->date_expected = $tracking->date_expected;
        $this->progress = $tracking->progress;
        $this->current_location = $tracking->current_location;
    }
}
