<?php

namespace App\Livewire\Settings;

use App\Livewire\Forms\ConfigForm;
use App\Models\Setting;
use Livewire\Component;

class Config extends Component
{
    public $config;
    public ConfigForm $config_form;
    
    public function render() {
        return view('livewire.settings.config');
    }

    public function mount() {
        $this->config_form->set($this->config);
    }

    public function update() {
        $this->validate();

        $settings = Setting::find(1);
        $settings->update([
            'email_config' => $this->config_form->all(),
        ]);

        $this->dispatch('settings-updated', 'Email configuration updated successfully.');
    }
}
