<?php

namespace App\Livewire\Shipment;

use App\Models\Shipment;
use Livewire\Component;

class All extends Component
{
    public function render() {
        return view('livewire.shipment.all', [
            'shipments' => Shipment::latest()->get(),
        ]);
    }

    public function delete_single($id) {
        $shipment = Shipment::find($id);
        $shipment->tracking()->delete();
        $shipment->delete();

        $this->dispatch('shipment-deleted', 'Shipment and associated tracking deleted successfully.');
    }
}
