<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class MailConfigServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        if (Schema::hasTable('settings')) {
            $settings = Setting::find(1);
            if ($settings->email_config) {
                $config = array(
                    'driver'     => $settings->email_config->driver,
                    'host'       => $settings->email_config->host,
                    'port'       => $settings->email_config->port,
                    'from'       => array('address' => $settings->site_email, 'name' => $settings->site_name),
                    'encryption' => $settings->email_config->encryption,
                    'username'   => $settings->email_config->username,
                    'password'   => $settings->email_config->password,
                    'sendmail'   => '/usr/sbin/sendmail -bs',
                    'pretend'    => false,
                );
                Config::set('mail', $config);
            }
        }
    }
}
