<form x-data="contact" method="POST" @submit.prevent="send" autocomplete="on">
    <div class="row">
        <div class="alert alert-danger" x-show="errors.general">
            <template x-for="error in errors.general">
                <span x-text="error"></span>
            </template>
        </div>

        <div class="alert alert-success" x-show="success" x-text="success" x-cloak></div>
        <div class="col-sm-6">
            <div class="mb-3">
                <label>Name <small>*</small></label>
                <x-widgets.alpine.input name="name" x-model="contact.name" placeholder="Enter Name" />
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mb-3">
                <label>Email <small>*</small></label>
                <x-widgets.alpine.input type="email" name="email" x-model="contact.email"
                    placeholder="Enter Email" />
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="mb-3">
                <label>Subject <small>*</small></label>
                <x-widgets.alpine.input name="subject" x-model="contact.subject" placeholder="Enter Subject" />
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mb-3">
                <label>Phone</label>
                <x-widgets.alpine.input name="phone" x-model="contact.phone" placeholder="Enter Phone" />
            </div>
        </div>
    </div>
    <div class="mb-3">
        <label>Message <small>*</small></label>
        <x-widgets.alpine.textarea name="message" x-model="contact.message" rows="5"
            placeholder="Enter Message" />
    </div>
    <div class="mb-3">
        <x-widgets.alpine.action-button text="Send message" />
    </div>
</form>
