<x-widgets.modal x-data="send_receiver_email" id="send-email" title="Send Email to {{ $shipment->receiver_email }}" size="xl">
    <div class="row my-5" x-init="set(@js($shipment))">
        <div class="col-md-6">
            <label class="fw-bold">Receiver Name</label>
            <x-widgets.alpine.input name="name" x-model="form.name" type="email" readonly />
        </div>

        <div class="col-md-6">
            <label class="fw-bold">Subject</label>
            <x-widgets.alpine.input name="subject" x-model="form.subject" />
        </div>
    </div>
    <div id="email-content"></div>
    <template x-for="error in errors.content">
        <div class="text-danger" x-text="error"></div>
    </template>
    <x-slot:footer>
        <x-widgets.alpine.action-button class="btn btn-primary" text="Send" @click.prevent="send" />
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" @email-sent.window="$el.click()">Close</button>
    </x-slot:footer>
</x-widgets.modal>

<script>
    $(document).ready(function() {
        $('#email-content').summernote({
            placeholder: 'Send email to {{ $shipment->receiver_email }}',
            height: 240,
        });
    });
</script>