<table class="table table-hover mt-2">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Tracking&nbsp;Code</th>
            <th>Receiver&nbsp;Name</th>
            <th>Destination</th>
            <th>Date&nbsp;Sent</th>
            <th>Date&nbsp;Expected</th>
            <th>Amount</th>
            <th>Status</th>
            <th>Current&nbsp;Location</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        @forelse ($shipments as $shipment)
            @php
                $tracking = $shipment->tracking;
            @endphp
            <tr class="cursor-pointer">
                <td>{{ $id++ }}</td>
                <td class="fw-bold">{{ $shipment->tracking_code }}</td>
                <td> {{ $shipment->receiver_name }}</td>
                <td>{{ $shipment->receiver_country }}</td>
                <td> {{ $tracking->date_sent->format('d/m/y') }}</td>
                <td> {{ $tracking->date_expected->format('d/m/y') }}</td>
                <td> {{ $settings->currency . $shipment->amount }}</td>
                <td>
                    <div
                        class="d-flex align-items-center text-{{ status_class($tracking->status_code) }}">
                        <span
                            class="badge-dot me-2 bg-{{ status_class($tracking->status_code) }}"></span>
                        <span class="text-capitalize">{!! status($tracking->status_code) !!}</span>
                    </div>
                </td>
                <td>{{ $tracking->current_location }}</td>
                <td><a href="{{ route('shipment.single', $shipment->tracking_code) }}" class="btn btn-sm btn-primary" wire:navigate>View</a></td>
            </tr>
            @empty
            <tr class="text-center">
                <td colspan="10">
                    No shipments yet. <br>
                    <a href="{{ route('shipment.create') }}" wire:navigate><i>Create new shipment</i></a>
                </td>
            </tr>
        @endforelse
    </tbody>

</table>