
<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo e($title); ?> | <?php echo e($settings->site_name); ?></title>
    <meta name="description" content="Logistex - Transport & Logistics HTML Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" href="<?php echo e($settings->site_favicon); ?>" type="image/x-icon" />
    <!-- CSS here -->
    <link rel="stylesheet" href="/home-assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="/home-assets/css/animate.min.css">
    <link rel="stylesheet" href="/home-assets/css/magnific-popup.css">
    <link rel="stylesheet" href="/home-assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="/home-assets/css/flaticon.css">
    <link rel="stylesheet" href="/home-assets/css/odometer.css">
    <link rel="stylesheet" href="/home-assets/css/swiper-bundle.css">
    <link rel="stylesheet" href="/home-assets/css/jquery-ui.css">
    <link rel="stylesheet" href="/home-assets/css/aos.css">
    <link rel="stylesheet" href="/home-assets/css/default.css">
    <link rel="stylesheet" href="/home-assets/css/default-icons.css">
    <link rel="stylesheet" href="/home-assets/css/main.css">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
     <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>    
    <script src="//unpkg.com/alpinejs" defer></script>
</head>

<body class="theme-blue">

    <!--Preloader-->
    <div id="preloader">
        <div class="tg-preloader-block">
            <div class="tg-spinner-eff">
                <div class="tg-bar tg-bar-top"></div>
                <div class="tg-bar tg-bar-right"></div>
                <div class="tg-bar tg-bar-bottom"></div>
                <div class="tg-bar tg-bar-left"></div>
            </div>
        </div>
    </div>
    <!--Preloader-end -->

    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fas fa-angle-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <!-- header-area -->
    <header>
        <div id="header-fixed-height"></div>
        <div class="tg-header__top">
            <div class="container-fluid p-0">
                <div class="row align-items-center">
                    <div class="col-xl-7">
                        <ul class="tg-header__top-info left-side list-wrap">
                            <li><i class="flaticon-location-1"></i><?php echo e($settings->site_address); ?></li>
                            <li><i class="flaticon-envelope"></i><a href="mailto:<?php echo e($settings->site_email); ?>"><?php echo e($settings->site_email); ?></a></li>
                        </ul>
                    </div>
                    <div class="col-xl-5">
                        <div class="tg-header__top-right">
                            <ul class="tg-header__top-menu list-wrap">
                                <li><a href="/contact">Help Center</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="sticky-header" class="tg-header__area">
            <div class="container-fluid p-0">
                <div class="row gx-0">
                    <div class="col-12">
                        <div class="tgmenu__wrap">
                            <div class="tgmenu__nav-left-side">
                                <div class="offcanvas-toggle">
                                    <a href="javascript:void(0)" class="menu-tigger">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none">
                                            <path d="M1.66669 15H28.3334M1.66669 6.66666H28.3334M1.66669 23.3333H28.3334" stroke="currentcolor" stroke-width="1.83333" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </a>
                                </div>
                                <div class="logo">
                                    <a href="/"><img src="<?php echo e($settings->site_logo); ?>" alt="Logo"></a>
                                </div>
                            </div>
                            <div class="tgmenu__navbar-wrap tgmenu__main-menu d-none d-xl-flex">
                                <ul class="navigation">
                                    <li><a href="/">Home</a></li>
                                    <li><a href="/about">About</a></li>
                                    <li><a href="/services">Services</a></li>
                                    <li><a href="/contact">Contact</a></li>
                                </ul>
                            </div>
                            <div class="tgmenu__action d-none d-md-flex">
                                <ul class="list-wrap">
                                    <li class="header-contact">
                                        <div class="icon">
                                            <i class="flaticon-telephone"></i>
                                        </div>
                                        <div class="content">
                                            <span>Call Us:</span>
                                            <a href="tel:<?php echo e($settings->site_phone); ?>"><?php echo e($settings->site_phone); ?></a>
                                        </div>
                                    </li>
                                    <li class="header-btn"><a href="/tracking" class="btn"><i class="flaticon-uptrend"></i>Track Order</a></li>
                                </ul>
                            </div>
                            <div class="mobile-nav-toggler">
                                <i class="tg-flaticon-menu-1"></i>
                            </div>
                        </div>

                        <!-- Mobile Menu  -->
                        <div class="tgmobile__menu">
                            <nav class="tgmobile__menu-box">
                                <div class="close-btn"><i class="tg-flaticon-close"></i></div>
                                <div class="nav-logo">
                                    <a href="/"><img src="<?php echo e($settings->site_logo); ?>" alt="Logo"></a>
                                </div>
                                <div class="tgmobile__menu-outer">
                                    <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                                </div>
                            </nav>
                        </div>
                        <div class="tgmobile__menu-backdrop"></div>
                        <!-- End Mobile Menu -->

                    </div>
                </div>
            </div>
        </div>
        <div id="google_translate_element"></div>

<script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
}
</script>

<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        <!-- offCanvas-menu -->
        <div class="offCanvas__info">
            <div class="offCanvas__close-icon menu-close">
                <button><i class="far fa-window-close"></i></button>
            </div>
            <div class="offCanvas__logo mb-30">
                <a href="/"><img src="<?php echo e($settings->site_logo); ?>" alt="Logo"></a>
            </div>
            <div class="offCanvas__side-info mb-30">
                <div class="contact-list mb-30">
                    <h4>Office Address</h4>
                    <p><?php echo e($settings->site_address); ?></p>
                </div>
                <div class="contact-list mb-30">
                    <h4>Phone Number</h4>
                    <p><?php echo e($settings->site_phone); ?></p>
                </div>
                <div class="contact-list mb-30">
                    <h4>Email Address</h4>
                    <p><?php echo e($settings->site_phone); ?></p>
                </div>
            </div>
        </div>
        <div class="offCanvas__overly"></div>
        <!-- offCanvas-menu-end -->

    </header>
    <!-- header-area-end -->

    <!-- main-area -->
    <main class="fix">
         <?php echo e($slot); ?>


    </main>
    <!-- main-area-end -->

    <!-- footer-area -->
    <footer class="footer__area fix">
        <div class="container">
            <div class="cta__wrap fix">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <div class="cta__content">
                            <h3 class="title">Fastest & secure way to transport <br> anything anytime</h3>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="cta__btn text-end">
                            <a href="services.html" class="btn btn-two">Request a Quote <img src="/home-assets/img/icon/right_arrow.svg" alt="" class="injectable"></a>
                        </div>
                    </div>
                </div>
                <div class="cta__shape">
                    <img src="/home-assets/img/images/cta_shape.png" alt="img" data-aos="fade-up-right" data-aos-delay="400">
                </div>
            </div>
            <div class="footer__top">
                <div class="row">
                    <div class="col-xl-4 col-lg-5 col-md-6">
                        <div class="footer__widget">
                            <div class="footer__logo">
                                <a href="/"><img src="<?php echo e($settings->site_alt_logo); ?>" alt="logo"></a>
                            </div>
                            <div class="footer__content">
                                <p><?php echo e($settings->site_name); ?> and Diplomatic Company offers reliable, fast, and secure delivery solutions worldwide. Your trusted partner for seamless logistics and exceptional service.</p>
                            </div>
                            <form action="#" class="footer__newsletter">
                                <div class="form-grp">
                                    <input type="email" placeholder="enter your e-mail">
                                    <button type="submit">Subscribe</button>
                                </div>
                                <span>We don’t send you any spam</span>
                            </form>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-4 col-md-6 col-sm-6">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title">Our Services</h4>
                            <div class="footer__link">
                                <ul class="list-wrap">
                                    <li><a href="/">Home</a></li>
                                    <li><a href="/about">About</a></li>
                                    <li><a href="/services">Services</a></li>
                                    <li><a href="/contact">Contact</a></li>
                                    <li><a href="/tracking">Tracking</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-8 col-md-12">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title">Information</h4>
                            <div class="footer__info-wrap">
                                <ul class="list-wrap">
                                    <li>
                                        <i class="flaticon-location-1"></i>
                                        <p><?php echo e($settings->site_address); ?></p>
                                    </li>
                                    <li>
                                        <i class="flaticon-telephone"></i>
                                        <a href="tel:<?php echo e($settings->site_phone); ?>"><?php echo e($settings->site_phone); ?></a>
                                    </li>
                                    <li>
                                        <i class="flaticon-envelope"></i>
                                        <a href="tel:<?php echo e($settings->site_email); ?>"><?php echo e($settings->site_email); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer__bottom">
                <div class="row align-items-center">
                    <div class="col-md-7">
                        <div class="copyright-text">
                            <p>Copyright <a href="/">©<?php echo e($settings->site_domain); ?></a> | All Right Reserved</p>
                        </div>
                    </div>
                    <div class="col-md-5">
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__shape">
            <img src="/home-assets/img/images/footer_shape01.png" alt="shape" data-aos="fade-down" data-aos-delay="400">
            <img src="/home-assets/img/images/footer_shape02.png" alt="shape" data-aos="fade-left" data-aos-delay="400">
        </div>
    </footer>
    <!-- footer-area-end -->



    <!-- JS here -->
    <script src="/home-assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="/home-assets/js/bootstrap.bundle.min.js"></script>
    <script src="/home-assets/js/jquery.magnific-popup.min.js"></script>
    <script src="/home-assets/js/jquery.counterup.min.js"></script>
    <script src="/home-assets/js/jquery.appear.js"></script>
    <script src="/home-assets/js/swiper-bundle.min.js"></script>
    <script src="/home-assets/js/svg-inject.min.js"></script>
    <script src="/home-assets/js/ajax-form.js"></script>
    <script src="/home-assets/js/jquery.marquee.min.js"></script>
    <script src="/home-assets/js/jquery-ui.min.js"></script>
    <script src="/home-assets/js/wow.min.js"></script>
    <script src="/home-assets/js/aos.js"></script>
    <script src="/home-assets/js/main.js"></script>
    <script src="/home-assets/js/pages.js"></script>
    <script>
        SVGInject(document.querySelectorAll("img.injectable"));
    </script>
    <?php echo $settings->live_chat; ?>

</body>

</html><?php /**PATH /home/infosfg/peakbaslogistics.com/resources/views/components/layouts/page.blade.php ENDPATH**/ ?>