<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Shipment;

class DashboardController extends Controller
{
    public function index() {
        return view('admin.dashboard', [
            'total' => Shipment::all(),
            'active' => Shipment::where('is_active', true)->get(),
            'inactive' => Shipment::where('is_active', false)->get(),

            'total_revenue' => Shipment::sum('amount'),
            'recent_shipments' => Shipment::latest()->take(5)->get(),
        ]);
    }
}
