<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('admin_id')->default(1)->constrained()->onDelete('cascade');
            $table->string('sender_name');
            $table->string('sender_email');
            $table->string('sender_country');
            $table->string('sender_address');
            $table->string('sender_phone');
            $table->string('receiver_name');
            $table->string('receiver_email');
            $table->string('receiver_country');
            $table->string('receiver_address');
            $table->string('receiver_phone');
            $table->string('amount');
            $table->string('description');
            $table->string('weight');
            $table->string('photo')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('tracking_code')->unique();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipments');
    }
};
