<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trackings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shipment_id')->constrained()->onDelete('cascade');
            $table->string('status_code')->default(1);
            $table->dateTime('date_sent');
            $table->dateTime('date_expected');
            $table->string('progress')->default(0);
            $table->string('current_location');
            $table->string('hold_reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * 0 = Held
     * 1 = Order Placed
     * 2 = Processing
     * 3 = Shipped
     * 4 = Delivered
     * 5 = Picked up
     */

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trackings');
    }
};
