<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;

use App\Models\Setting;
use App\Models\Shipment;
use App\Models\Tracking;
use App\Models\Admin;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        Admin::factory(1)->create();

        Setting::create([
            'site_name' => fake()->company(),
            'site_url' => fake()->url(),
            'site_domain' => fake()->domainName(),
            'site_email' => fake()->companyEmail(),
            'site_address' => fake()->address(),
            'site_phone' => fake()->phoneNumber(),
            'email_config' => [
                'driver' => 'smtp',
                'host' => 'localhost',
                'port' => 1025,
                'username' => null,
                'password' => null,
                'encryption' => null,
            ]
        ]);
    }
}