<x-layouts.dashboard title="Contact Message">
    <x-widgets.page-header title="Contact Message">
    </x-widgets.page-header>

    <div class="container">
        <div class="card">
            <div class="card-body">

                <div class="mt-5">
                    <h5>Message Details</h5>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Details</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Name</td>
                                <td>
                                    {{ $contact->name }}
                                </td>
                            </tr>

                            <tr>
                                <td>Email</td>
                                <td>
                                    {{ $contact->email }}
                                </td>
                            </tr>

                            <tr>
                                <td>Phone</td>
                                <td>
                                    {{ $contact->phone }}
                                </td>
                            </tr>

                            <tr>
                                <td>Subject</td>
                                <td>
                                    {{ $contact->subject }}
                                </td>
                            </tr>

                            <tr>
                                <td>Message</td>
                                <td>
                                    {{ $contact->message }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="border-top my-3"></div>

                <div class="row">
                    <div class="col-xl-6 col-sm-12 col-md-12">
                        <button class="btn btn-info mb-2" data-bs-toggle="modal" data-bs-target="#send-email">
                            <i class="feather icon-mail"></i> Reply contact
                        </button>
                        <button class="btn btn-danger mb-2" data-bs-toggle="modal" data-bs-target="#delete-contact">
                            <i class="feather icon-trash-2"></i> Delete Contact
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <x-widgets.modal x-data="send_receiver_email" id="send-email" title="Send Email to {{ $contact->email }}" size="xl">
        <div class="row my-5" x-init="set(@js($contact))">
            <div class="col-md-6">
                <label class="fw-bold">Receiver Name</label>
                <x-widgets.alpine.input name="name" x-model="form.name" type="email" readonly />
            </div>

            <div class="col-md-6">
                <label class="fw-bold">Subject</label>
                <x-widgets.alpine.input name="subject" x-model="form.subject" />
            </div>
        </div>
        <div id="email-content"></div>
        <template x-for="error in errors.content">
            <div class="text-danger" x-text="error"></div>
        </template>
        <x-slot:footer>
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                @email-sent.window="$el.click()">Close</button>
            <x-widgets.alpine.action-button class="btn btn-primary" text="Send" @click.prevent="send" />
        </x-slot:footer>
    </x-widgets.modal>

    <x-widgets.modal id="delete-contact" title="Deleting contact..." x-data="delete_contact">
        Are you sure you want to delete this?
        <x-slot:footer>
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                @email-sent.window="$el.click()">Close</button>
            <x-widgets.alpine.action-button class="btn btn-danger" text="Yes, delete"
                @click.prevent="delete_single({{ $contact->id }})" />
        </x-slot:footer>
    </x-widgets.modal>
    <script>
        $(document).ready(function() {
            $('#email-content').summernote({
                placeholder: 'Send email to {{ $contact->email }}',
                height: 240,
            });
        });
    </script>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>

</x-layouts.dashboard>
