<x-layouts.dashboard title="All Trackings">
    <x-widgets.page-header title="All Trackings">
        <div class="breadcrumb-item"><a href="javascript:void(0)"> Manage Trackings </a></div>
    </x-widgets.page-header>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive-sm table-responsive-md">
                <table class="table table-bordered" id="trackings-table">
                    <thead>
                        <tr>
                            <th>
                                S/N
                            </th>
                            <th class="fw-bold">Tracking&nbsp;Code</th>
                            <th>Status</th>
                            <th>Date&nbsp;Sent</th>
                            <th>Date&nbsp;Expected</th>
                            <th>Progress</th>
                            <th>Current&nbsp;Location</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($trackings as $tracking)
                            <tr>
                                <td>{{ $id++ }}</td>
                                <td>{{ $tracking->shipment->tracking_code }}</td>
                                <td>
                                    <div
                                        class="d-flex align-items-center text-{{ status_class($tracking->status_code) }}">
                                        <span
                                            class="badge-dot me-2 bg-{{ status_class($tracking->status_code) }}"></span>
                                        <span class="text-capitalize">{!! status($tracking->status_code) !!}</span>
                                    </div>
                                </td>
                                <td>{{ $tracking->date_sent->format('d/m/Y') }}</td>
                                <td>{{ $tracking->date_expected->format('d/m/Y') }}</td>
                                <td>{{ $tracking->progress }}%</td>
                                <td>{{ $tracking->current_location }}</td>

                                <td class="text-end">
                                    <div class="dropdown">
                                        <a href="#" class="px-2" data-bs-toggle="dropdown">
                                            <i class="feather icon-more-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a href="{{ route('tracking.single', $tracking->id) }}"
                                                    class="dropdown-item" wire:navigate>
                                                    <div class="d-flex align-items-center">
                                                        <i class="feather icon-eye"></i>
                                                        <span class="ms-2">View Tracking</span>
                                                    </div>
                                                </a>
                                            </li>

                                            <li>
                                                <a href="{{ route('tracking.edit', $tracking->id) }}"
                                                    wire:navigate class="dropdown-item">
                                                    <div class="d-flex align-items-center">
                                                        <i class="feather icon-edit"></i>
                                                        <span class="ms-2">Edit Tracking</span>
                                                    </div>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        $('#trackings-table').DataTable({
            columnDefs: [{
                targets: [7],
                orderable: false
            }]
        });
    </script>

    @if (session('success'))
        <script>
            toast.success(@js(session('success')))
        </script>
    @endif
</x-layouts.dashboard>
