<form wire:submit.prevent="login">
    <div class="form-group mb-3">
        <label class="form-label">Email</label>
        <x-form.input 
            name="email" 
            wire:model="email" 
            placeholder="username@domain.com" 
        />
    </div>
    <div class="mb-3">
        <label class="form-label d-flex justify-content-between">
            <span>Password</span>
            <a wire:navigate href="{{ route('reset-password') }}" class="text-primary font">Forget Password?</a>
        </label>
        <div class="form-group input-affix flex-column" x-data="toggle_password">
            <label class="d-none">Password</label>
            <x-form.password
                name="password" 
                wire:model="password"
                x-ref="password"
            />
        </div>
        <div class="form-check mt-2">
            <input class="form-check-input" type="checkbox" wire:model="remember" id="remember">
            <label class="form-check-label ms-2" for="remember">
                Remember me
            </label>
        </div>
    </div>
    <x-form.submit target="login" text="Login" loading-text="Logging in..." />
</form>
