<section>
    @if (!$settings->updated)
    <div class="alert alert-warning">Please, update your settings.</div>
@endif
<form wire:submit.prevent="update" @settings-updated.window="toast.success($event.detail)">
    <div class="row mb-3">
        <h5 class="lead">Site Information</h5>
        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Name</label>
            <x-form.input name="settings_form.site_name" wire:model="settings_form.site_name" />
        </div>

        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Url</label>
            <x-form.input name="settings_form.site_url" wire:model="settings_form.site_url" />
        </div>


        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Domain</label>
            <x-form.input name="settings_form.site_domain" wire:model="settings_form.site_domain" />
        </div>

        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Email</label>
            <x-form.input name="settings_form.site_email" wire:model="settings_form.site_email" />
        </div>

        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Phone</label>
            <x-form.input name="settings_form.site_phone" wire:model="settings_form.site_phone" />
        </div>

        <div class="col-md-12 mt-3">
            <label class="fw-bold">Site Address</label>
            <x-form.input name="settings_form.site_address" wire:model="settings_form.site_address" />
        </div>
    </div>

    <hr>

    <div class="row mt-3 mb-3">
        <h5 class="lead">Site Logos</h5>
        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Logo</label>
            <x-form.input name="settings_form.site_logo" wire:model="settings_form.site_logo" type="file" />
        </div>

        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Favicon</label>
            <x-form.input name="settings_form.site_favicon" wire:model="settings_form.site_favicon" type="file" />
        </div>


        <div class="col-md-4 mt-3">
            <label class="fw-bold">Site Alt Logo</label>
            <x-form.input name="settings_form.site_alt_logo" wire:model="settings_form.site_alt_logo" type="file" />
        </div>
    </div>

    <hr>

    <div class="row mt-3 mb-3">
        <h5 class="lead">Site Metrics</h5>
        <div class="col-md-6 mt-3">
            <label class="fw-bold">Currency</label>
            <x-form.input name="settings_form.currency" wire:model="settings_form.currency" />
        </div>

        <div class="col-md-6 mt-3">
            <label class="fw-bold">Weight Unit</label>
            <x-form.input name="settings_form.weight_unit" wire:model="settings_form.weight_unit" />
        </div>
    </div>

    <hr>

    <div class="row mt-3">
        <h5 class="lead">Live Support</h5>
        <div class="col-12 mt-3">
            <label class="fw-bold">Tidio, Tawk.to, etc</label>
            <x-form.textarea name="settings_form.live_chat" wire:model="settings_form.live_chat" />
        </div>
    </div>

    <div class="row mt-4">
        <x-form.submit target="update" text="Update settings" />
    </div>
</form>
</section>