<?php
$admin = auth()->user();
?>
<div class="header-text-dark header-nav layout-vertical">
    <div class="header-nav-wrap">
        <div class="header-nav-left">
            <div class="header-nav-item desktop-toggle">
                <div class="header-nav-item-select cursor-pointer">
                    <i class="nav-icon feather icon-menu icon-arrow-right"></i>
                </div>
            </div>
            <div class="header-nav-item mobile-toggle">
                <div class="header-nav-item-select cursor-pointer">
                    <i class="nav-icon feather icon-menu icon-arrow-right"></i>
                </div>
            </div>
        </div>
        <div class="header-nav-right">
            <div class="header-nav-item">
                <div class="dropdown header-nav-item-select nav-profile">
                    <div class="toggle-wrapper" id="nav-profile-dropdown" data-bs-toggle="dropdown">
                        <div class="avatar avatar-circle avatar-image"
                            style="width: 35px; height: 35px; line-height: 35px;">
                            <img src="/assets/images/avatars/thumb-1.jpg" alt="">
                        </div>
                        <span class="fw-bold mx-1"><?php echo e($admin->name); ?></span>
                        <i class="feather icon-chevron-down"></i>
                    </div>
                    <div class="dropdown-menu dropdown-menu-end">
                        <div class="nav-profile-header">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-circle avatar-image">
                                    <img src="/assets/images/avatars/thumb-1.jpg" alt="">
                                </div>
                                <div class="d-flex flex-column ms-1">
                                    <span class="fw-bold text-dark"><?php echo e($admin->name); ?></span>
                                    <span class="font-size-sm"><?php echo e($admin->email); ?></span>
                                </div>
                            </div>
                        </div>
                        <a wire:navigate href="<?php echo e(route('profile')); ?>" class="dropdown-item">
                            <div class="d-flex align-items-center">
                                <i class="font-size-lg me-2 feather icon-user"></i>
                                <span>Profile</span>
                            </div>
                        </a>
                        <a wire:navigate href="<?php echo e(route('settings.general')); ?>" class="dropdown-item">
                            <div class="d-flex align-items-center">
                                <i class="font-size-lg me-2 feather icon-settings"></i>
                                <span>Settings</span>
                            </div>
                        </a>
                        <a href="<?php echo e(route('logout')); ?>" class="dropdown-item text-danger" @click.prevent="logout" x-data="logout">
                            <span x-show="!processing">
                                <i class="feather icon-power text-danger"></i>
                                <span class="nav-menu-item-title">Logout</span>
                            </span>
            
                            <span x-show="processing" x-cloak>
                                <i class="feather icon-refresh-ccw text-danger"></i>
                                <span class="nav-menu-item-title fst-italic">Logging out...</span>
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/consolac/fastwaylogistics.org/resources/views/partials/header.blade.php ENDPATH**/ ?>