<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8" />
    <title>Invoice - <?php echo e($shipment->tracking_code); ?></title>

    <style>
        .invoice-box {
            max-width: 800px%;
            margin: auto;
            padding: 30px;
            border: 1px solid #29abe2;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
            font-size: 12px;
            line-height: 18px;
            font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            color: #555;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 5px;
            vertical-align: top;
            font-weight: bolder;
        }

        .invoice-box table tr td:nth-child(2) {
            text-align: right;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 45px;
            line-height: 45px;
            color: #333;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 40px;
        }

        .invoice-box table tr.heading td {
            background: #29abe2;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
            color: white;
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #29abe2;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #29abe2;
            font-weight: bold;
        }

        @media only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }

        /** RTL **/
        .invoice-box.rtl {
            direction: rtl;
            font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
        }

        .invoice-box.rtl table {
            text-align: right;
        }

        .invoice-box.rtl table tr td:nth-child(2) {
            text-align: left;
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <table cellpadding="0" cellspacing="0">
            <tr class="top">
                <td colspan="2">
                    <table>
                        <tr>
                            <td class="title">
                                <img src="<?php echo e(public_path($settings->site_logo)); ?>" style="width: 60%; max-width: 300px" />
                            </td>

                            <td>
                                <b>Tracking Code</b>: <b><?php echo e($shipment->tracking_code); ?></b><br>
                                <b>Date Sent</b>: <?php echo e($tracking->date_sent->format('F j, Y')); ?><br>
                                <b>Date Expected</b>: <?php echo e($tracking->date_expected->format('F j, Y')); ?> <br>
                                <b>Invoice created at</b>: <?php echo e(now()->format('F j, Y')); ?>

                            </td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="heading">
                <td>Sender Details</td>

                <td></td>
            </tr>

            <tr class="item">
                <td>Name</td>
                <td><?php echo e($shipment->sender_name); ?></td>
            </tr>

            <tr class="item">
                <td>Email</td>
                <td><?php echo e($shipment->sender_email); ?></td>
            </tr>

            <tr class="item">
                <td>Address</td>
                <td><?php echo e($shipment->sender_address); ?></td>
            </tr>

            <tr class="item">
                <td>Phone</td>
                <td><?php echo e($shipment->sender_phone); ?></td>
            </tr>

            <tr class="item">
                <td>Country</td>
                <td><?php echo e($shipment->sender_country); ?></td>
            </tr>

            <tr>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td></td>
                <td></td>
            </tr>

            <tr class="heading">
                <td>Receiver Details</td>

                <td></td>
            </tr>

            <tr class="item">
                <td>Name</td>
                <td><?php echo e($shipment->receiver_name); ?></td>
            </tr>

            <tr class="item">
                <td>Email</td>
                <td><?php echo e($shipment->receiver_email); ?></td>
            </tr>

            <tr class="item">
                <td>Address</td>
                <td><?php echo e($shipment->receiver_address); ?></td>
            </tr>

            <tr class="item">
                <td>Phone</td>
                <td><?php echo e($shipment->receiver_phone); ?></td>
            </tr>

            <tr class="item">
                <td>Country</td>
                <td><?php echo e($shipment->receiver_country); ?></td>
            </tr>


            <tr>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td></td>
                <td></td>
            </tr>

            <tr class="heading">
                <td>Shipment Information</td>

                <td></td>
            </tr>

            <tr class="item">
                <td>Name</td>
                <td><?php echo e($shipment->receiver_name); ?></td>
            </tr>

            <tr class="item">
                <td>Description</td>
                <td><?php echo e($shipment->description); ?></td>
            </tr>

            <tr class="item">
                <td>Weight</td>
                <td><?php echo e($shipment->weight . $settings->weight_unit); ?></td>
            </tr>

            <?php if($shipment->photo): ?>
                <tr class="item">
                    <td>Photo</td>
                    <td>
                        <a href="<?php echo e(asset($shipment->photo)); ?>" target="_blank">Click to view</a>
                    </td>
                </tr>
            <?php endif; ?>

            <tr>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td></td>
                <td></td>
            </tr>

            <tr class="heading">
                <td>Tracking Information</td>

                <td></td>
            </tr>

            <tr class="item">
                <td>Status</td>
                <td><?php echo e(status($tracking->status_code)); ?></td>
            </tr>

            <?php if($tracking->status_code == 0): ?>
                <tr class="item">
                    <td>Hold Reason</td>
                    <td><?php echo e($tracking->hold_reason); ?></td>
                </tr>
            <?php endif; ?>

            <tr class="item">
                <td>Date Sent</td>
                <td><?php echo e($tracking->date_sent->format('F j, Y')); ?></td>
            </tr>

            <tr class="item">
                <td>Expected Date of Arrival</td>
                <td><?php echo e($tracking->date_expected->format('F j, Y')); ?></td>
            </tr>

            <tr class="item">
                <td>Progress</td>
                <td><?php echo e($tracking->progress); ?>%</td>
            </tr>

            <tr class="item">
                <td>Current Location</td>
                <td><?php echo e($tracking->current_location); ?></td>
            </tr>


            <tr class="total">
                <td></td>

                <td>Total: <?php echo e($settings->currency . number_format($shipment->amount, 2)); ?></td>
            </tr>
        </table>
    </div>
</body>

</html>
<?php /**PATH /home/infosfg/peakbaslogistics.com/resources/views/admin/shipment/invoice.blade.php ENDPATH**/ ?>