<table class="table table-hover mt-2">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Tracking&nbsp;Code</th>
            <th>Receiver&nbsp;Name</th>
            <th>Destination</th>
            <th>Date&nbsp;Sent</th>
            <th>Date&nbsp;Expected</th>
            <th>Amount</th>
            <th>Status</th>
            <th>Current&nbsp;Location</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $tracking = $shipment->tracking;
            ?>
            <tr class="cursor-pointer">
                <td><?php echo e($id++); ?></td>
                <td class="fw-bold"><?php echo e($shipment->tracking_code); ?></td>
                <td> <?php echo e($shipment->receiver_name); ?></td>
                <td><?php echo e($shipment->receiver_country); ?></td>
                <td> <?php echo e($tracking->date_sent->format('d/m/y')); ?></td>
                <td> <?php echo e($tracking->date_expected->format('d/m/y')); ?></td>
                <td> <?php echo e($settings->currency . $shipment->amount); ?></td>
                <td>
                    <div
                        class="d-flex align-items-center text-<?php echo e(status_class($tracking->status_code)); ?>">
                        <span
                            class="badge-dot me-2 bg-<?php echo e(status_class($tracking->status_code)); ?>"></span>
                        <span class="text-capitalize"><?php echo status($tracking->status_code); ?></span>
                    </div>
                </td>
                <td><?php echo e($tracking->current_location); ?></td>
                <td><a href="<?php echo e(route('shipment.single', $shipment->tracking_code)); ?>" class="btn btn-sm btn-primary" wire:navigate>View</a></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr class="text-center">
                <td colspan="10">
                    No shipments yet. <br>
                    <a href="<?php echo e(route('shipment.create')); ?>" wire:navigate><i>Create new shipment</i></a>
                </td>
            </tr>
        <?php endif; ?>
    </tbody>

</table><?php /**PATH /home/infosfg/peakbaslogistics.com/resources/views/partials/shipment-table.blade.php ENDPATH**/ ?>