<div>
    <table class="table table-bordered" id="shipments-table" @shipment-deleted.window="toast.success($event.detail)" wire:ignore.self>
        <thead>
            <tr>
                <th>S/N</th>
                <th class="fw-bold">Tracking&nbsp;Code</th>
                <th>Sender&nbsp;Name</th>
                <th>Receiver&nbsp;Name</th>
                <th>Destination</th>
                <th>Date&nbsp;Sent</th>
                <th>Date&nbsp;Expected</th>
                <th>Status</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $tracking = $shipment->tracking;
                ?>
                <tr>
                    <td><?php echo e($id++); ?></td>
                    <td class="fw-bold"><?php echo e($shipment->tracking_code); ?> <i x-data class="icon-copy feather" role="button" @click="$clipboard(<?php echo \Illuminate\Support\Js::from($shipment->tracking_code)->toHtml() ?>, $el)"></i></td>
                    <td><?php echo e($shipment->sender_name); ?></td>
                    <td><?php echo e($shipment->receiver_name); ?></td>
                    <td><?php echo e($shipment->receiver_country); ?></td>
                    <td><?php echo e($tracking->date_sent->format('d/m/y')); ?></td>
                    <td><?php echo e($tracking->date_expected->format('d/m/y')); ?></td>

                    <td>
                        <div class="d-flex align-items-center text-<?php echo e(status_class($tracking->status_code)); ?>">
                            <span class="badge-dot me-2 bg-<?php echo e(status_class($tracking->status_code)); ?>"></span>
                            <span class="text-capitalize"><?php echo status($tracking->status_code); ?></span>
                        </div>
                    </td>

                    <td class="text-end">
                        <div class="dropdown">
                            <a href="#" class="px-2" data-bs-toggle="dropdown">
                                <i class="feather icon-more-vertical"></i>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a href="<?php echo e(route('shipment.single', $shipment->tracking_code)); ?>"
                                        class="dropdown-item" wire:navigate>
                                        <div class="d-flex align-items-center">
                                            <i class="feather icon-eye"></i>
                                            <span class="ms-2">View Shipment</span>
                                        </div>
                                    </a>
                                </li>

                                <li>
                                    <a href="<?php echo e(route('shipment.edit', $shipment->tracking_code)); ?>" wire:navigate class="dropdown-item">
                                        <div class="d-flex align-items-center">
                                            <i class="feather icon-edit"></i>
                                            <span class="ms-2">Edit Shipment</span>
                                        </div>
                                    </a>
                                </li>

                                <li>
                                    <a href="javascript:void(0)" class="dropdown-item text-danger" x-data
                                        data-bs-toggle="modal" data-bs-target="#delete-single"
                                        @click="$dispatch('shipment-deleting', <?php echo e($shipment); ?>)">
                                        <div class="d-flex align-items-center">
                                            <i class="feather icon-trash-2"></i>
                                            <span class="ms-2">Delete Shipment</span>
                                        </div>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
        </tbody>
    </table>
    <?php echo $__env->make('partials.delete-shipment-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php /**PATH /home/infosfg/dbschnell-logistics.org/resources/views/livewire/shipment/all.blade.php ENDPATH**/ ?>